// // // // // // // // // // // // // // // //
//
//	ElementListe.h
//
//	erstellt 15.2.98 von Andreas Warnke
//	geändert 15.2.98 von Andreas Warnke
//



#ifndef __ElementList_h
#define __ElementList_h



// // // // // // // // // // // // // // // //
//
//	defines AND includes
//

#include "Element.h"

class Element;
typedef Element * ElementPointer;



// // // // // // // // // // // // // // // //
//
//	Plan:
//
//	ElementList A    ElementList B
//	 First = &a       First = &c
//	 F_Pos = 1....... F_Pos = 1_____
//	 Last = &c      : Last = &d     |
//	 L_Pos = 0      : L_Pos = 0_____|_______________
//	 Finger = &b    : Finger = NULL |               |
//	 F_Pos = 0......: F_Pos         |               |
//	 F_ListPos = 1 :: F_ListPos     |               |
//	 Count = 3     :: Count = 2     |               |
//                 ::               |               |
// ................::               |               |
// :               :                |               |
// :Element a      : Element b      | Element c     |  Element d
// : Prev[0]       :..Prev[0] = &1  |..Prev[0] = &b |_ _Prev[0] = &c
// : P_Pos[0]       : P_Pos[0] = 1  |: P_Pos[0] = 0   | P_Pos[0] = 1
// : Next[0]        : Next[0] = &c  |: Next[0] = NULL | Next[0] = NULL
// : N_Pos[0]       : N_Pos[0] = 0...: N_Pos[0]       | N_Pos[0]
// : List[0]        : List[0] = &A  |  List[0] = &A   | List[0] = &B
// :.Prev[1] = NULL : Prev[1]       |__Prev[1] = NULL | Prev[1]
//	 P_Pos[1]       : P_Pos[1]         P_Pos[1]       | P_Pos[1]
//	 Next[1] = &b   : Next[1]          Next[1] = &d   | Next[1]
//	 N_Pos[1] = 0...: N_Pos[1]         N_Pos[1] = 0___| N_Pos[1]
//	 List[1] = &A     List[1]          List[1] = &B     List[1]
//



// // // // // // // // // // // // // // // //
//
//	ElementList
//

class ElementList
{
private:
	//	Zeiger auf Listenelemente:
	Element * TheFirst;
	int TheFirstPos;
	Element * TheLast;
	int TheLastPos;
	//	Finger
	ElementPointer TheFinger;
	int TheFingerPos;
	int TheFingerListPos;
	
	//	Listeninfos:
	int TheCount;

public:
	//	Konstruktor:
	ElementList ();
	
	//	Destruktor:
	virtual ~ElementList ();

	//	Insert
	bool Insert ( Element * inElement );
	
	//	Remove once
	bool Remove ( Element * inElement );
	
	//	GetElement
	Element * GetElement ( int inPos ); 
	
	//	HasElement
	bool HasElement ( const Element * inElement );
	
	//	Counter:
	int CountElements ();
	
	//	MakeEmpty
	void MakeEmpty ( bool inDelete = false );
};



#endif



//
//	Ende
//
// // // // // // // // // // // // // // // //